// Luminarpe 2.0
// Crée par Mathias Blandeau 2014


// DEBUT DU CODE LUMINARPE

const int cordeMax = 5; // total number of chords
const int debounceValue = 3; // value for debouncing the chord
int sensorPin[cordeMax]; // infrared measured 
const int analogPin[] = {A15, A14, A13, A12, A11};
const int potentioPin = A8;
const int ledPin = 13; // for debugging
const int irPin = 2; // infrared emitter alimentation
const int motorPin[] = {8, 9, 10, 11, 12}; // for vibrating motors

int corde = 0; // chord id
int potentioValue; 
int ambientIR; // infrared measure with the IR emitter OFF
int activeIR; // infrared measure with the IR emitter ON
int increment = 0;

int ledState[cordeMax]; // to know which chord is activated
float sensorTemp[cordeMax]; // difference between ambientIR and activeIR

int DEBUG = 0; // for debuggin 0:OFF, 1:ON
int debugMax = 251;

void setup(){
  Serial.begin(9600);
  pinMode(ledPin, OUTPUT);

  pinMode(irPin, OUTPUT);    // IR emitter LED on digital pin

  for(int i = 0 ; i < cordeMax ; i++){
    ledState[i] = 0;               // Initialize all ledState to 0
    sensorTemp[i] = 0;              // Initialize all sensorTemp to 0
    sensorPin[i] = analogPin[i]; 
    pinMode(motorPin[i], OUTPUT); // Vibrating Motor on digital pin
  }
}


void loop(){

  if (corde == cordeMax) corde = 0;
  
  digitalWrite(irPin,LOW);        // turning the IR LEDs off to read the IR coming from the ambient
  delay(1);                              // minimum delay necessary to read values
  ambientIR = analogRead(sensorPin[corde]);  // storing IR coming from the ambient in the middle of the harpe
  digitalWrite(irPin,HIGH);       // turning the IR LEDs on to read the IR coming from the obstacle
  delay(1);                              // minimum delay necessary to read values

  potentioValue = analogRead(potentioPin); // the potentiometre is to change the sensitivity off the chords (if light changes for example)

  activeIR = analogRead(sensorPin[corde]);

  sensorTemp[corde] = activeIR - ambientIR;
  

  if (sensorTemp[corde] > potentioValue)
  {
    if (ledState[corde] == 0){
      ledState[corde] += 1;
        Serial.write(corde); //communication with computer
        delay(100);
        motorActivation(corde); // function to activate motor differently
    }
    if (ledState[corde] == 1){
      motorActivation(corde); // function to activate motor differently
    }
  }
  else
  {
    if (ledState[corde] > 0){
      ledState[corde] -= 1;
      if(ledState[corde] == 0)
      {
        digitalWrite(motorPin[corde], LOW);
      }
    }
  }
  
  


  if (DEBUG){
    DEBUG += 1;

    if (DEBUG > debugMax){
      DEBUG = 1;

      Serial.println(corde);
      Serial.print("potar :  ");
      Serial.println(potentioValue);
      Serial.print("ambiant : ");
      Serial.println(ambientIR);
      Serial.print("activeIR : ");
      Serial.println(activeIR);
      Serial.print("sensorTemp : ");
      Serial.println(sensorTemp[corde]);
      Serial.print("Etar led : ");
      Serial.println(ledState[corde]);
      Serial.print("increment : ");
      Serial.println(increment);
      Serial.println("");  
    }
  }
  corde += 1; 
}

void motorActivation(int cordeID){
  if (increment == 100) increment = 0;
  increment = increment + 1;
  
  switch (cordeID) {
    case 0:
      if (increment < 10) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 20 && increment < 30) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 40 && increment < 50) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 60 && increment < 70) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 80 && increment < 90) digitalWrite(motorPin[cordeID], HIGH);
      else digitalWrite(motorPin[cordeID], LOW);
      break;
    case 1:      
      if (increment < 20) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 40 && increment < 60) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 80) digitalWrite(motorPin[cordeID], HIGH);
      else digitalWrite(motorPin[cordeID], LOW);
      break;
    case 2:
      if (increment < 10) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 15 && increment < 25) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 60 && increment < 70) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 75 && increment < 85) digitalWrite(motorPin[cordeID], HIGH);
      else digitalWrite(motorPin[cordeID], LOW);
      break;
    case 3:
      if (increment < 30) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 60 && increment < 90) digitalWrite(motorPin[cordeID], HIGH);
      else digitalWrite(motorPin[cordeID], LOW);
      break;
    case 4:
      if (increment < 10) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 20 && increment < 30) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 40 && increment < 50) digitalWrite(motorPin[cordeID], HIGH);
      else if (increment > 80 && increment < 90) digitalWrite(motorPin[cordeID], HIGH);
      else digitalWrite(motorPin[cordeID], LOW);
      break;
  }  
}


