Forme Corde0;
Forme Corde1; 
Forme Corde2;
Forme Corde3; 
Forme Corde4;

PShape img0;
PShape img1;
PShape img2;
PShape img3;
PShape img4;

import ddf.minim.*;
import processing.serial.*;

Serial port; 
Minim minim;
AudioSample[] sons;

int ledId;
int bufferSize = 2000;
int disparition = 1000; // vitesse à laquelle la forme disparaît
int vitesse = 2; // vitesse des formes
int taille = 40; // tailles des formes
int vibration = 60; // force des vibrations des images
int ondes = 180; // la taille des sinusoïdes
int epaisseur = 20; // l'épaisseur des cordes

void setup() {
  size(800,800);
  minim = new Minim(this);
  
  // setup port   
  port = new Serial(this, Serial.list()[0], 9600); 

  
  sons = new AudioSample[5];
  sons[0] = minim.loadSample("250Hz3.mp3",bufferSize);
  sons[1] = minim.loadSample("FeuArtifice2.mp3",bufferSize);
  sons[2] = minim.loadSample("SabreLaser2.mp3",bufferSize);
  sons[3] = minim.loadSample("Synthe2.mp3",bufferSize);
  sons[4] = minim.loadSample("1kHz2.mp3",bufferSize);
  
  Corde0 = new Forme(color(255,0,0),0,height*1/6,vitesse,4); 
  Corde1 = new Forme(color(0,0,255),0,height*2/6,vitesse,5);
  Corde2 = new Forme(color(0,255,0),0,height*3/6,vitesse,6);
  Corde3 = new Forme(color(0,255,255),0,height*4/6,vitesse,7);
  Corde4 = new Forme(color(255,0,255),0,height*5/6,vitesse,8);
  
//  img0 = loadShape("chach.svg");
//  img1 = loadShape("huitzilopotchli.svg");
//  img2 = loadShape("itzamna.svg");
//  img3 = loadShape("ixchel.svg");
//  img4 = loadShape("kukulkan.svg");
}


void draw() {
  fill(0,disparition);
  noStroke();
  rect(0, 0, width, height);
  
  ledId = port.read();
  switch(ledId) {
    case 0: sons[0].trigger();sons[0].setGain(-5);break;
    case 1: sons[1].trigger();sons[1].setGain(-10);break;
    case 2: sons[2].trigger();sons[2].setGain(-10);break;
    case 3: sons[3].trigger();sons[3].setGain(-10);break;
    case 4: sons[4].trigger();sons[4].setGain(-10);break;
  }
   
//  if (sons[0].mix.get(bufferSize/3) != 0) {
//    Corde0.drive();
//    Corde0.display();
//  }
//  if (sons[1].mix.get(bufferSize/3) != 0) {
//    Corde1.drive();
//    Corde1.display();
//  }
//  if (sons[2].mix.get(bufferSize/3) != 0) {
//    Corde2.drive();
//    Corde2.display();
//  }
//  if (sons[3].mix.get(bufferSize/3) != 0) {
//    Corde3.drive();
//    Corde3.display();
//  }
//  if (sons[4].mix.get(bufferSize/3) != 0) {
//    Corde4.drive();
//    Corde4.display();
//  }

// use the mix buffer to draw the waveforms.
  for (int i = 0; i < sons[0].bufferSize() - 1; i++)
  {
    float x1 = map(i, 0, sons[0].bufferSize(), 0, width);
    float x2 = map(i+1, 0, sons[0].bufferSize(), 0, width);
   
    // pouce
    stroke(255,0,0);
    pushMatrix();
    translate(200,0);
    rotate(PI/4);
    line(x1, height/2 - sons[0].mix.get(i) * ondes, x2, height/2 + epaisseur - sons[0].mix.get(i+1) * ondes);
    popMatrix();
    
    // index
    stroke(255,255,0);
    pushMatrix();
    translate(615,-80);
    rotate(PI*5/12);
    line(x1, height/2 - sons[1].mix.get(i) * ondes, x2, height/2 + epaisseur - sons[1].mix.get(i+1) * ondes);
    popMatrix();

    // majeur    
    stroke(0,255,0);
    pushMatrix();
    translate(835,0);
    rotate(PI/2);
    line(x1, height/2 - sons[2].mix.get(i) * ondes, x2, height/2 + epaisseur - sons[2].mix.get(i+1) * ondes);
    popMatrix();
    
    // annulaire
    stroke(0,255,255);
    pushMatrix();
    translate(30,700);
    rotate(-PI*5/12);
    line(x1, height/2 - sons[3].mix.get(i) * ondes, x2, height/2 + epaisseur - sons[3].mix.get(i+1) * ondes);
    popMatrix();
    
    // auriculaire
    stroke(0,0,255);
    pushMatrix();
    translate(50,650);
    rotate(-PI/3);
    line(x1, height/2 - sons[4].mix.get(i) * ondes, x2, height/2 + epaisseur - sons[4].mix.get(i+1) * ondes);
    popMatrix();
  }
}


void keyPressed(){
  switch(key){
    case('a'): sons[0].trigger();break;
    case('z'): sons[1].trigger();break;
    case('e'): sons[2].trigger();break;
    case('r'): sons[3].trigger();break;
    case('t'): sons[4].trigger();break;
    case('c'):
    sons[0].trigger();
    sons[1].trigger();
    sons[2].trigger();
    sons[3].trigger();
    sons[4].trigger();
    break;
  }
}

void stop()
{
  // always close Minim audio classes when you are done with them
  sons[0].close();
  sons[1].close();
  sons[2].close();
  sons[3].close();
  sons[4].close();
  minim.stop();
 
  super.stop();
}

// Even though there are multiple objects, we still only need one class. 
// No matter how many cookies we make, only one cookie cutter is needed.
class Forme { 
  color c;
  float xpos;
  float ypos;
  float xspeed;
  int shape;
  float decalage;

  // The Constructor is defined with arguments.
  Forme(color tempC, float tempXpos, float tempYpos, float tempXspeed, int tempShape) { 
    c = tempC;
    xpos = tempXpos;
    ypos = tempYpos;
    xspeed = tempXspeed;
    shape = tempShape;
  }

  void display() {
    
    decalage = (sons[0].mix.get(bufferSize/3) + sons[1].mix.get(bufferSize/3) + sons[2].mix.get(bufferSize/3) + sons[3].mix.get(bufferSize/3) + sons[4].mix.get(bufferSize/3)) * vibration;
    println(decalage);

    img0.disableStyle();
    img1.disableStyle();
    img2.disableStyle();
    img3.disableStyle();
    img4.disableStyle();
    stroke(c);
    //fill(c);
    
    //choix de la forme
    switch(shape){
    case(1): ellipse(xpos + taille, ypos, taille, taille);break;
    case(2): rect(xpos, ypos, taille, taille);break;
    case(3): quad(xpos, ypos, xpos - taille/2, ypos - taille, xpos + taille, ypos - taille/2, xpos, ypos + taille);break;
    case(4): shape(img0,xpos - (img0.width*taille/100)/2,ypos - (img0.height*taille/100)/2 + decalage,img0.width*taille/100,img0.height*taille/100);break;
    case(5): shape(img1,xpos - (img1.width*taille/100)/2,ypos - (img1.height*taille/100)/2 + decalage,img1.width*taille/100,img1.height*taille/100);break;
    case(6): shape(img2,xpos - (img2.width*taille/100)/2,ypos - (img2.height*taille/100)/2 + decalage,img2.width*taille/100,img2.height*taille/100);break;
    case(7): shape(img3,xpos - (img3.width*taille/100)/2,ypos - (img3.height*taille/100)/2 + decalage,img3.width*taille/100,img3.height*taille/100);break;
    case(8): shape(img4,xpos - (img4.width*taille/100)/2,ypos - (img4.height*taille/100)/2 + decalage,img4.width*taille/100,img4.height*taille/100);break;
  }
    
  }

  void drive() {
    xpos = xpos + xspeed;
    if (xpos > width) {
      xpos = 0;
    }
  }
}
