Forme Corde0;
Forme Corde1; 
Forme Corde2;
Forme Corde3; 
Forme Corde4;

PShape img;

import ddf.minim.*;
import processing.serial.*;

Serial port; 
Minim minim;
AudioSample[] sons;

int ledId;
int bufferSize = 2000;
int disparition = 10; // vitesse à laquelle la forme disparaît
int vitesse = 3; // vitesse des formes
int taille = 40; // tailles des formes
int vibration = 150; // force des vibrations des images

void setup() {
  size(750,750);
  minim = new Minim(this);
  
  // setup port   
  port = new Serial(this, Serial.list()[0], 9600); 

  
  sons = new AudioSample[5];
  sons[0] = minim.loadSample("001.mp3",bufferSize);
  sons[1] = minim.loadSample("002.mp3",bufferSize);
  sons[2] = minim.loadSample("003.mp3",bufferSize);
  sons[3] = minim.loadSample("004.mp3",bufferSize);
  sons[4] = minim.loadSample("005.mp3",bufferSize);
  
  Corde0 = new Forme(color(255,0,0),0,height*1/6,vitesse,4); 
  Corde1 = new Forme(color(0,255,0),0,height*2/6,vitesse,4);
  Corde2 = new Forme(color(255,255,0),0,height*3/6,vitesse,4);
  Corde3 = new Forme(color(255,0,255),0,height*4/6,vitesse,4);
  Corde4 = new Forme(color(0,255,255),0,height*5/6,vitesse,4);
  
  img = loadShape("syd.svg");
}


void draw() {
  fill(0,disparition);
  noStroke();
  rect(0, 0, width, height);
  
  ledId = port.read();
  switch(ledId) {
    case 0: sons[0].trigger();sons[0].setGain(15);break;
    case 1: sons[1].trigger();sons[1].setGain(20);break;
    case 2: sons[2].trigger();sons[2].setGain(10);break;
    case 3: sons[3].trigger();sons[3].setGain(15);break;
    case 4: sons[4].trigger();sons[4].setGain(15);break;
  }
   
  if (sons[0].mix.get(bufferSize/3) != 0) {
    Corde0.drive();
    Corde0.display();
  }
  if (sons[1].mix.get(bufferSize/3) != 0) {
    Corde1.drive();
    Corde1.display();
  }
  if (sons[2].mix.get(bufferSize/3) != 0) {
    Corde2.drive();
    Corde2.display();
  }
  if (sons[3].mix.get(bufferSize/3) != 0) {
    Corde3.drive();
    Corde3.display();
  }
  if (sons[4].mix.get(bufferSize/3) != 0) {
    Corde4.drive();
    Corde4.display();
  }
}


void keyPressed(){
  switch(key){
    case('a'): sons[0].trigger();break;
    case('z'): sons[1].trigger();break;
    case('e'): sons[2].trigger();break;
    case('r'): sons[3].trigger();break;
    case('t'): sons[4].trigger();break;
    case('c'):
    sons[0].trigger();
    sons[1].trigger();
    sons[2].trigger();
    sons[3].trigger();
    sons[4].trigger();
    break;
  }
}

void stop()
{
  // always close Minim audio classes when you are done with them
  sons[0].close();
  sons[1].close();
  sons[2].close();
  sons[3].close();
  sons[4].close();
  minim.stop();
 
  super.stop();
}

// Even though there are multiple objects, we still only need one class. 
// No matter how many cookies we make, only one cookie cutter is needed.
class Forme { 
  color c;
  float xpos;
  float ypos;
  float xspeed;
  int shape;
  float decalage;

  // The Constructor is defined with arguments.
  Forme(color tempC, float tempXpos, float tempYpos, float tempXspeed, int tempShape) { 
    c = tempC;
    xpos = tempXpos;
    ypos = tempYpos;
    xspeed = tempXspeed;
    shape = tempShape;
  }

  void display() {
    
    decalage = (sons[0].mix.get(bufferSize/3) + sons[1].mix.get(bufferSize/3) + sons[2].mix.get(bufferSize/3) + sons[3].mix.get(bufferSize/3) + sons[4].mix.get(bufferSize/3)) * vibration;
//    println(decalage);

    img.disableStyle();
    //stroke(c);
    fill(c);
    
    //choix de la forme
    switch(shape){
    case(1): ellipse(xpos + taille, ypos, taille, taille);break;
    case(2): rect(xpos, ypos, taille, taille);break;
    case(3): quad(xpos, ypos, xpos - taille/2, ypos - taille, xpos + taille, ypos - taille/2, xpos, ypos + taille);break;
    case(4): shape(img,xpos - (img.width*taille/100)/2,ypos - (img.height*taille/100)/2 + decalage,img.width*taille/100,img.height*taille/100);break;
  }
    
  }

  void drive() {
    xpos = xpos + xspeed;
    if (xpos > width) {
      xpos = 0;
    }
  }
}
