// Pin 13 et 2 has LED and pin 7 has buzzer.
// Analog pin 0 has photoresistor.
int led1 = 13;
int led2 = 2;
int buzzer = 7;
int photoResistor = 0;

// the setup routine runs once when you press reset:
void setup() {
  // initialize the digital pins as output.
  pinMode(led1, OUTPUT);
  pinMode(led2, OUTPUT);
  pinMode(buzzer, OUTPUT);
  pinMode(photoResistor, OUTPUT);
  // open the serial port at 9600 bps:
  Serial.begin(9600);
}

// the loop routine runs over and over again forever:
void loop() {
    // read the photoResistor value
  	int light  = analogRead(photoResistor);   //log light values to Serial Monitor
  	Serial.print("Light value :");
  	Serial.println(light); // print the photoresistor value in the Serial monitor
  
  if (light < 500) {      // leds blink when light is high, buzzer is off
    // buzzer make noise when there is less light, leds are off
    digitalWrite(buzzer, HIGH); // turn buzzer on
    //LEDs eteintes
  	digitalWrite(led1, LOW);   // turn the LED off by making the voltage LOW
    digitalWrite(led2, LOW);  
  }  
  else {   
    digitalWrite(buzzer, LOW); // turn buzzer off	
    // LEDs allumée
  	digitalWrite(led1, HIGH);   // turn the LED on (HIGH is the voltage level)
    digitalWrite(led2, HIGH);
    delay(100); // wait 100 ms
    //LEDs éteintes
  	digitalWrite(led1, LOW);   // turn the LED off by making the voltage LOW
    digitalWrite(led2, LOW);  
    delay(100); 
  }
  delay(500);
}
