import time

from PIL import Image
from PIL import ImageDraw
from PIL import ImageFont

import board
import digitalio
from adafruit_htu21d import HTU21D
import adafruit_ssd1306


# Use for I2C.
i2c = board.I2C()

# Definition du capteur de temperature
sensor = HTU21D(i2c)

# Initialisation de l'ecran
oled_reset = digitalio.DigitalInOut(board.D4)

OLED_WIDTH = 128
OLED_HEIGHT = 32  # Change to 64 if needed
OLED_ADDR = 0x3C
oled = adafruit_ssd1306.SSD1306_I2C(
    OLED_WIDTH, OLED_HEIGHT, i2c, addr=OLED_ADDR, reset=oled_reset
)

# re-initialisation de l'ecran.
oled.fill(0)
oled.show()

# Load defChargement de la police par defaut.
font = ImageFont.load_default()

while True:
    # On dessine l'image a afficher en se basant sur un un fichier
    image = Image.open('tree-32.pbm')
    draw = ImageDraw.Draw(image)

    # on affiche les valeur lues sur le capteur en bas de l'image
    temp = "%0.1f°C" % sensor.temperature
    humidity = "%0.0f%%" % sensor.relative_humidity
    draw.text((1, 23), temp,  font=font, fill=255)
    draw.text((110, 23), humidity, font=font, fill=255)

    # On affiche l'image dessinée sur l'ecran
    oled.image(image)
    oled.show()
    time.sleep(1)
