#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
from gdesign import *

if len(sys.argv) != 2:
    sys.exit('Usage: %s filename' % sys.argv[0])

if not os.path.exists(sys.argv[1]):
    sys.exit('Error: %s was not found!' % sys.argv[1])

file = open(sys.argv[1])
filename = '.'.join(sys.argv[1].split('.')[:-1])

vertices = []
edges = []

for line in file:
    seq = line.split()
    if seq[0] == 'v':
        vertices.append([float(seq[1]),float(seq[2])])
    elif seq[0] == 'l':
        edges.append([int(seq[1]),int(seq[2])])

file.close()

path_list = []
while len(edges):
    path_list.append(edges.pop())
    i = 0
    while i < len(edges):
        if edges[i][0] == path_list[-1][-1]:
            path_list[-1].append(edges[i][1])
            edges = edges[:i]+edges[i+1:]
            i = 0
        elif edges[i][1] == path_list[-1][-1]:
            path_list[-1].append(edges[i][0])
            edges = edges[:i]+edges[i+1:]
            i = 0
        elif edges[i][1] == path_list[-1][0]:
            path_list[-1].insert(0,edges[i][0])
            edges = edges[:i]+edges[i+1:]
            i = 0
        elif edges[i][0] == path_list[-1][0]:
            path_list[-1].insert(0,edges[i][1])
            edges = edges[:i]+edges[i+1:]
            i = 0
        else:
            i+=1

s = Svg()
for item in path_list:
    path = Path()
    path.new_sub_path()
    poly = Polyline()
    for i in item:
        poly.add_node(Point(vertices[i-1][0],vertices[i-1][1]))
    path.add(poly)
    s.add(path)

s.write(filename+'.svg')
